/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.listener;

import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shared.listeners.LoginProfileEvent;
import net.skinsrestorer.shared.listeners.LoginProfileListener;
import net.skinsrestorer.shared.storage.Config;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoin
extends LoginProfileListener
implements Listener {
    private static boolean resourcePack;
    private final SkinsRestorer plugin;

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        LoginProfileEvent profileEvent = this.wrap(event);
        if (this.handleSync(profileEvent)) {
            return;
        }
        if (resourcePack && Config.RESOURCE_PACK_FIX) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.handleAsync(profileEvent).ifPresent(name -> {
            try {
                this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(event.getPlayer()), (String)name);
            }
            catch (SkinRequestException e) {
                this.plugin.getSrLogger().debug(e);
            }
        }));
    }

    private LoginProfileEvent wrap(final PlayerJoinEvent event) {
        return new LoginProfileEvent(){

            @Override
            public boolean isOnline() {
                return Bukkit.getOnlineMode();
            }

            @Override
            public String getPlayerName() {
                return event.getPlayer().getName();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
    }

    public PlayerJoin(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }

    public static void setResourcePack(boolean resourcePack) {
        PlayerJoin.resourcePack = resourcePack;
    }
}

